/*
 * File:    mcf5xxx.s
 * Purpose: Lowest level routines for all ColdFire processors.
 *
 * Notes:   
 *
 * License:     All software covered by license agreement in -
 *              docs/Freescale_Software_License.pdf
 */

#define boot_exception_handler   _boot_exception_handler

    .extern boot_exception_handler

    .global asm_exception_handler
    .global _asm_exception_handler
    .text

/********************************************************************
 * This routine is the lowest-level exception handler.
 */
 
asm_exception_handler:
_asm_exception_handler:
    lea     -16(SP),SP
    movem.l D0-D1/A0-A1,(SP)
    lea     16(SP),A1
    move.l  A1,-(SP)
    jsr     boot_exception_handler
    lea     4(SP),SP
    movem.l (SP),D0-D1/A0-A1
    lea     16(SP),SP
    rte

/********************************************************************/
    .end
